/** @module digbase
  @mainpage dig - A GUI Library for D
  @section introduction Introduction

  The dig library provides a wrapper for OS GUIs, currently only
  Windows 95+'s.  It should be considered pre-alpha state, with
  minimal functionality.  dig is in the public domain, with the
  exception of net.BurtonRadons.dig.windows.windows, which is LGPL.
  
  @section overview Overview

  Downloads are available at the @ref downloads page.  dig comes with a
  build utility called @ref digc.
  
  You can get a summary at the @ref summary page.

  The main class hierarchy to dig begins with the abstract Control class;
  the most important one is the Frame, which is a window control.  The
  registry is encapsulated in the Registry std.math.singleton.  Once installed, use
  "import net.BurtonRadons.dig.main;" to get the main controls;
  use "import net.BurtonRadons.dig.gl;" to get the
  CanvasGL class and the many components of that.

  @section compilation Compilation

  You will first need DMD; get it by going 
  <a href="http://www.digitalmars.com/d/alpha.html">here</a> and
  downloading both files.  dig expects that DMD and DMC are
  installed in the root directory of the current drive and are
  properly working.
  
  Compile and install dig by running the "go.bat" program in the
  install directory.

  If there is a complaint with an error message like
  "c:\dmd\bin\..\..\bin", then you need to reinstall DMD as there
  was an incorrect sc.ini version.  Likewise, if you get a complaint
  from lib.exe about not providing a library, unzip dmdalpha.zip
  again to overwrite the incorrect version in dmc.zip.
  
  Once it's installed, it'll automatically build and run one of the
  example programs.  The examples directory contains other stuff
  to play with.
  
  @section usage Usage
  
  To use dig in your programs, you generally make files of the form:
  
  @code
  // Import dig - doesn't import CanvasGL or ScintillaText.
  import net.BurtonRadons.dig.main;
  
  class Program : Frame
  {
      this ()
      {
          caption ("Hello program");
          
          with (new Label (this))
          {
              grid (0, 0);
              caption ("Hello, world!");
          }
      }
  }
  
  void main ()
  {
     (new Program).showModal ();
  }
  @endcode

  */
  
/**

  @page summary Library Summary
  
  Here's a summary of the classes in dig.
  
  @section control Controls
  
  A Control is a visual widget.  The usual top-level control is the Frame.
  Here are the subclasses of Control:
  
  <ul>
  <li>#Button - Push button with text label.
  <li>#Canvas - User-drawn control.
  <li>#CanvasGL - OpenGL control.
  <li>#CheckBox - %Label with an on/off button.
  <li>#ComboBox - Selects between multiple text values.
  <li>#EditText - Single or multiple-line input text editor.
  <li>#Frame - Window.
  <li>#GroupBox - Labelled border around a set of controls.
  <li>#Label - Single line text control.
  <li>#ListBox - Multiple-column list.
  <li>#Pane - Gridfitting organizer.
  <li>#RadioButton - Sets of these allow selecting between multiple values.
       #RadioGroup can be used to easily manage sets of this control.
  <li>#ScintillaText - Interface to a Scintilla text editing control.
  <li>#Spinner - Numerical input.
  <li>#TreeBox - Multiple-column tree view.
  </ul>
  
  @section dispatchers Dispatchers
  
  For handling events, you register delegates with dispatchers - lists of
  delegates.  The normal dispatcher type is Dispatcher.  You add a
  delegate using add; it takes these forms:
  
  @code
  void delegate () func;
  void delegate (Event event) func;
  Dispatcher *reference;
  @endcode
  
  The "Event" structure has many fields, most of which aren't used for any one
  event type.  When I list the dispatchers I'll type out what fields they use in
  parentheses.  The field "flags" refers to the control, lbutton, mbutton, rbutton,
  and shift fields. 
  
  Here are the main dispatchers to control.  First, the general
  dispatchers:
  
  <ul>
  <li>onDrop - Files have been dropped onto the control.  This uses the #DropDispatcher object.
  <li>onHelp - Help has been requested for this control.  If this delegate is empty, the message is passed to the control's parent.
  <li>onHScroll (scrollType, scrollPoint) - A horizontal scrollbar action has been requested.  If this delegate is empty, it will change the hscrollPoint according to the horizontal scroll page and range settings.
  <li>onPaint (left, top, right, bottom) - Painting has been requested.  This event is only spawned with Canvas and CanvasGL subclasses.
  <li>onVScroll (scrollType, scrollPoint) - A verical scrollbar action has been requested.  If this delegate is empty, it will change the vscrollPoint according to the horizontal scroll page and range settings.
  <li>onSizeChanged (x, y) - The dimensions of the control have changed.  x and y contain the previous width and height.
  </ul>
  
  Here are the keyboard-related dispatchers:
  
  <ul>
  <li>onChar (keyCode, keyRepeat, keyPrevious) - The character has been pressed on the keyboard and this control has focus.
  <li>onLostFocus - The control no longer has keyboard focus.
  </ul>
  
  Here are the mouse-related dispatchers:
  
  <ul>
  <li>onLButtonDown (x, y, flags) - The left mouse button has been pressed while over the control.
  <li>onLButtonUp (x, y, flags) - The left mouse button has been released while over the control.
  <li>onMButtonDown (x, y, flags) - The middle mouse button has been pressed while over the control.
  <li>onMButtonUp (x, y, flags) - The middle mouse button has been released while over the control.
  <li>onMouseLeave - The mouse cursor has moved off the control.
  <li>onMouseOver (x, y) - The mouse cursor has moved over the control.
  <li>onMouseWheel (x, y, flags, wheel) - The mouse wheel has been spun while the control has the keyboard focus.
  <li>onRButtonDown - The right mouse button has been pressed while over the control.
  <li>onRButtonUp - The right mouse button has been released while over the control.
  </ul>
  
  @section dialog Standard Dialogs
  
  There are a set of standard dialog classes for performing
  common operations.  These dialogs are:
  
  <ul>
  <li>#ColorSelector - Show a color selection dialog.
  <li>#FileSelector - Select one or many files for loading or saving.
  <li>#FontSelector - Select a system font.
  </ul>
  
  @section bitmap Bitmaps
  
  The Bitmap class manages an image you can use to draw onto a Canvas.
  You can load bitmaps from files using the BitmapLoad function.  You can
  also draw onto bitmaps using a set of classes starting with Brush, which
  returns a color.  Its sub-classes are:
  
  <ul>
  <li>#BrushBitmap - Sample the brush from a bitmap.
  <li>#BrushBlend - Blend between multiple brushes using Photoshop-style layers.
  <li>#BrushColor - Use a std.math.single color.
  <li>#BrushFilter - Run a convolution filter on a child brush.
  <li>#BrushGradient - Sample a linear or radial gradient.
  <li>#BrushNoise - Randomly distort the color of a child brush.
  </ul>
  
  Brushes and bitmaps can both be convolved.  When applied to brushes,
  convolutions change the sample position.  When applied to bitmaps,
  convolutions distort shape points.  The convolutions are:
  
  <ul>
  <li>#RotateContorter - Rotate a number of degrees around a point.
  <li>#SwimContorter - Move the sample position in a wave pattern.
  <li>#TransformContorter - Apply a transformation matrix to the position.
  </ul>
  
  @section math Mathematics
  
  There are a large number of mathematics structures with names
  typecasted after OpenGL 2.0.  These are:
  
  <ul>
  <li>#box2 - Two-dimensional axis-aligned bounding box.
  <li>#box3 - Three-dimensional axis-aligned bounding box.
  <li>#mat2 - Two-by-two matrix.
  <li>#mat3 - Three-by-three matrix.
  <li>#mat4 - Four-by-four matrix.
  <li>#obb3 - Three-dimensional oriented bounding box.
  <li>#plane3 - Three-dimensional half-space equation.
  <li>#quat3 - Three-dimensional rotation quaternion.
  <li>#ray3 - Three-dimensional ray (source plus direction).
  <li>#sphere3 - Three-dimensional sphere.
  <li>#vec2 - Two-dimensional vector.
  <li>#vec3 - Three-dimensional vector.
  <li>#vec4 - Four-dimensional vector.
  </ul>

  */

/**

  @page digc digc
  
  Compilation can be done normally using DMD, but dig comes with a
  program that makes this process much easier, called digc.
  
  This is a compiler wrapper for DMD that creates executables with
  a std.math.single line.  Take the examples programs command:
  
  @code
  digc halhello.d / cartoon.d -then=cartoon -windowed -O -release
  @endcode
  
  This first builds halhello.exe using halhello.d as source.  The "/"
  separates programs; they share options.  Then it builds cartoon.exe
  using cartoon.d as source, IF halhello.exe compiled successfully.
  The "-then" indicates a command to run if all compilation succeeded;
  in this case it runs the cartoon example.
  
  -windowed compiles these programs as windowed programs; if it's not given,
  console programs are made instead.  You do not need to use "WinMain";
  the normal main will work properly.
  
  -O and -release are arguments for DMD; any argument digc doesn't understand
  is passed along.  Note that you don't specify the libraries to use.  Instead, 
  digc identifies the necessary libraries automatically, and I'll describe this
  presently.

  To build an executable of a certain name, use "-exe=" followed by the
  name without extension; for example, "-exe=halhello".

  @section library Compiling Libraries

  To create a library, use "-lib=" followed by the name without extension.  When you
  compile a library, digc notes the libraries that were given on the command
  line as well as the filenames themselves, and stores them in a central
  registry (/dmd/lib/libraries.dat).  It is important for the .d files to be compiled
  in the same way that they would be imported.  For example, if a user should
  import file.d using "import package.file;", then be sure to have
  "digc package/file.d" when compiling, and not "digc file.d".

  This information is used in later compilations to discover what libraries the
  executable needs to be linked with.  digc does this by searching the files
  for import statements and seeing whether the import file is mentioned in the
  registry; if so, it includes the library and its dependencies in the command
  line.

  You can create shared libraries - DLLs in Windows - by adding the "-shared"
  option.  For those who have been doing this before: digc automatically creates
  a DllMain and exports all public symbols.  For those who haven't done it before,
  it makes the program behave similarly to Linux.  However, the main program
  and each DLL will have their own independent GC, so data can't be shared
  between them.

  */

/**

  @page downloads Downloads and Changelog
  
  @section v0_0_14 Version 0.0.14
  
  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.14.zip">dig-0.0.14.zip</A>
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.14.zip">dig_html-0.0.14.zip</A>
  - dedit: Tweaks to undo to make it behave more responsively and not take up so much memory.
    It still needs to have an RLE scheme for character differencing.
  - TreeBox: Added.
  - ListBox: More and better semantics.  Rows now have dispatchers that take every translateable message.
  - dedit: Now uses TreeBox for the project view.  This is bound to have introduced bugs.
  - Canvas.textFont can now be used to get the current font.  The default canvas font is made the same as the
    normal font.  I fixed a bug where double-buffering will not get the right font while painting.  Finally, the font
    returned from Canvas.textFont is attached to the canvas, so modifying it causes the canvas text font to be
    changed automatically.
  - Canvas.textFont is REMOVED.  Use Control.font instead.
  - digc now checks the times of the source and dependencies and avoids compilation if files aren't modified.
    This is transitory, std.math.since it doesn't check that the compilation arguments are the same.
  - Updating for DMD 0.69.

  @section v0_0_13 Version 0.0.13

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.13.zip">dig-0.0.13.zip</A>
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.13.zip">dig_html-0.0.13.zip</A>
  - dedit: Fixes.  Changing projects no longer crashes inside the GC.
    Project/New puts the new document in the right place.  Saving a new
    document guesses the syntax highlighter.
  - onPaint event is now handed the region that should be painted, and Canvas uses this information to
    do minimal blitting.  You can repaint regions using Control.paintRegion.
  - dedit: Now redraws only the regions which have changed.  For fast computers using normal fonts this
    was a non-issue, but with slow computers or those using ClearType dedit was slow to work with.  It's
    now much faster.
  - dedit: Find (Control-F) has a new drop-down box to search based on syntax highlighting types.
  - dedit: Java syntax highlighter added.
  - digc: Now uses the "module" statement to change the filename to synthesize in recreation.
  - digc: It now passes a page size of 32 to lib.exe, which was bitching when compiling dig.lib with -g on.
  - Checkbox renamed CheckBox to align to the other Boxes.
  - Directory structure change for hygiene and porting concerns.  Use "import net.BurtonRadons.dig.main;" to import dig
    and "import net.BurtonRadons.dig.gl;" to import diggl.
  - Control.SearchList renamed to Control.listPath.
  - Bitmap constructor doesn't require a Control any more.
  - I'm starting to move to UNICODE.  Character strings should be treated as UTF-8 from now on, although
    DMD won't generate them as such yet.
  - Control.focus (control) is no more.  Use control.makeFocus () and control.clearFocus ().
  - All private symbols have been renamed with a digPlatform or digCommon prefix.  There were about five
    different prefix systems in use, it's now standardised.
  - Started the summary page.

  @section v0_0_12 Version 0.0.12

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.12.zip">dig-0.0.12.zip</A>
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.12.zip">dig_html-0.0.12.zip</A>
  - dedit has been made better in many ways.  I am now using Visual Studio 7.0, which cannot be cajoled
    into editing D code properly, and I have been very unimpressed with other editors, so I now use dedit
    entirely.  This means it should be made a better editor very quickly.
  - dedit: Control-Left and Control-Right have been added.  I have been wanting a word-left/-right that was actually
    useful for programming for years now.  I suggest experimenting with it; I think you'll like it much better
    than other editors' handling of this command for macro processing.
  - dedit: Macro recording/playback.
  - You can now install DMD wherever you want so long as you edit the makefile's BASEDIR line to point
    to the location.
  
  @section v0_0_11 Version 0.0.11

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.11.zip">dig-0.0.11.zip</A>
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.11.zip">dig_html-0.0.11.zip</A>
  - The "-w" option for digc has been changed to "-windowed".
  - libpng is now loaded when needed rather than being linked in.  Faster startup times, less memory use.
  - digc acts a little better now.
  - dstripcopy tool removes unnecessary whitespace from files and function bodies, resulting in faster compilation -
    compiling the cartoon example with the stripped headers is 59% faster than with the full headers.  timerun tool
    just times execution.
  - digc can create DLLs if you supply the -shared option.  It creates the def file (which exports all public symbols,
    like on Linux), generates the import library, and creates a valid DllMain.
  - Brought in dfilter utility, which I use with Doxygen to make D code more suitable for it.
  - Added -install option to digc, which moves the created files into their appropriate locations.
  - When compiling libraries, digc now puts the stripped headers at the end of the .lib file and
    generates those when the library is used, thus removing the need to install anything other
    than the .lib file.
  - Ported over much more of brlib's vector mathematics.  This meant lots more functions for
    vectors, plane3, ray3, box3, sphere3, and quat3.
  - Added image loading support for libjpeg.  Documented ImageLoader a little better.
  - Added image loading support for TGA.  Doesn't support palettised images.
  - Started taking out multiple symbols between digwindows.d and Phobos' windows.d.

  @section v0_0_10 Version 0.0.10

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.10.zip">dig-0.0.10.zip</A>
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.10.zip">dig_html-0.0.10.zip</A>
  - System mouse cursors are now supported in Control.cursor.  The enumeration it takes, Control.Cursor, has a
    diagram showing typical cursors.
  - digc now handles the version statement in determining whether something is really included.
    It also defines the WindowsXP version as appropriate, more to follow.
  - digc creates a resource file containing a manifest so that visual themes are used under Windows XP.
    Custom-drawn controls also use themes and should be backwards portable to previous versions of Windows.
  - Control.onMouseOver is sent when the mouse enters the control's region, paired before the mouseMove.
  - Control.onMouseLeave is sent when the mouse leaves the control's space (Windows 98 and up presently).
  - Timers don't use interrupts anymore, but are instead part of the message feed.
  - Handling the scrollbars is easier now; you only need to use vscrollRange and vscrollPage, and vscrollPoint
    will be updated by onVScroll when it's empty.  The same applies for the horizontal scrollbars.
  - Resizing the window with an empty onResize resizes its contents as appropriate for its stickiness.
  - Event.deltax and .deltay contain the cursor change std.math.since the last onMouseMove, or zeroes for the first incidence.
  - Start of a ListBox control.
  - Added a ScintillaText control contributed by Andy Friesen.
  - Updates for DMD 0.57.

  @section v0_0_9 Version 0.0.9

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.9.zip">dig-0.0.9.zip</A>
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.9.zip">dig_html-0.0.9.zip</A>
  - Changes to gridfitting require that you run the "display" method on a control before it's gridfit.  You can do this at any level.
  - digc now records library dependencies in a central registry.

  @section v0_0_8 Version 0.0.8

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.8.zip">dig-0.0.8.zip</A> (317Kb)
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.8.zip">dig_html-0.0.8.zip</A> (238Kb)
  - Took subtypes of GLFrame out into the open.  My only real worries are
    with vec[234]/mat[234], which are OpenGL 2.0-based and could easily
    collide.
  - Enriched vec* and mat* structs with eleven herbs and spices.
    Added plane3, box3, obb3, sphere3.
  - Added menu bars.  Recreation is not allowed presently, so windows with
    menu bars can't have their minimise/maximise/etc. buttons change.
  - Mild changes for DMD 0.49 and 0.50.
  - Event.keyCode is now a string instead of an enumeration.
  - Spinner: Added.  This is a very handy tool.
  - EditText.getFloat now handles expressions.
  - Control.onDrop message for file explorer drag/drop.
  - Renamed TextBox to Label.
  - GroupBox is now user-drawn as it was interfering with some message
    dispatching.
  - GLFrame.readPixels for reading a rectangle of data from one of the
    frame buffers.
  - GLFrame.textureCopyImage and GLtexture.copyImage for copying the
    color buffer into a texture.
  - digc now handles variable expansions so that I could install the dlls.
    It also handles multiple -then statements now.
  - GL functions have been moved into the GL class with a gl std.math.singleton, so
    that you don't need to pass around a redundant frame everywhere and can
    step into native symbol lookup.
  - GLFrame was renamed to CanvasGL; a Frame implies a Window.
  - RadioButton control added, as well as the RadioGroup helper.
  - dedit: Find dialog, invoked with Ctrl-F and find next with F3.  Be sure
    to check out the "Match List" button; you click on entries to show that
    point, and can select and delete them.
  - dedit: Horizontal scrollbar.

  @section v0_0_7 Version 0.0.7

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.7.zip">dig-0.0.7.zip</A> (183Kb)
  - Documentation Package: <A href="http://www.opend.org/dig/arc/dig_html-0.0.7.zip">dig_html-0.0.7.zip</A> (172Kb)
  - dedit: Made projects save with relative paths and allowed it to start from the command-line.
  - GroupBox: Fixed to, you know, work.  It should use a manually-drawn widget so that children can be subwindowed directly.
  - Now use a default font as the system default was driving me crazy.  Why this is my responsibility I'll never know.
  - Pane: Added.
  - dedit: Project folders.  Still clumsy.  Cheapo statistics tool.
  - dedit: Fixed copy/paste/undo bugs.
  - digc: Wasn't compiling multiple programs properly.  This was preventing the cartoon demo from being compiled.
  - dedit: Now gives an option to try to save files (to a different filename) after a crash.
  - CheckBox is no longer a subclass of Button.  This should be as flat as possible.

  @section v0_0_6 Version 0.0.6

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.6.zip">dig-0.0.6.zip</A>
  - Added Clipboard class, which has a std.math.singleton in Control::clipboard.
    Only supports text content for now.
  - dedit: Added undo and clipboard support.
  - dedit: Backspace is smart to indentation.
  - dedit: HTML syntax highlighting.  Basic as basic can be, but it's contextual.
  - digc now handles wildcards for filenames, used with dedit.
  - digc now builds libraries, used with dig.
  - FileSelector: selecting a std.math.single file in multiple-selection mode would return a cancel.
  - dedit: options dialog and session window.
  - Font: Saving to/loading from registry.
  - Registry: Set of "love" methods that either load or save depending upon a bit.
  - dedit: Project manager.

  @section v0_0_5 Version 0.0.5

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.5.zip">dig-0.0.5.zip</A> (159Kb)
  - Removed Registry std.math.singleton; it's now a field of Control (Control::registry).
  - ColorWhite, ColorBlack, and ColorTrans are now Color::White, Color::Black, and Color::Trans.
  - Added onClose message and fixed up its behaviour.
  - Better at freeing data.
  - Got rid of Painting, as it was increasingly difficult to see what on Earth it could be used for.
  - Made Canvas use real colors, none of this 0-100 nonsense.
  - Mouse capturing, keyboard lost focus message, #Font.textExtent.
  - Added support for scrollbars.
  - Started dedit example, a sample syntax-highlighting D editor.
    Gave it a bunch of highlighters for some reason.  It's plugin-based,
    to an extent; refactoring will make this clearer.
  - Control::onKeyDown, Control::onChar.
  - gc.fullCollect is now called every second.
  
  @section v0_0_4 Version 0.0.4 (October 28, 2002)
  
  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.4.zip">dig-0.0.4.zip</A> (124Kb)
  - Added ComboBox control.
  - Deleted windows.d and winutil.d; windows headers are now in digwindows.d, saving 40kb on executable size.
  - Added support for window resizing.  Nigh improveable.
  - Added Registry std.math.singleton for registry access.
  - Cartoon shader sample makes use of the registry, combobox, resizing, and has transparent shadows.
  - Added digc and used it for examples.
  - Removed WinMain requirements, digInit and digTerm.
  - Fixed keyboards.

  @section v0_0_3 Version 0.0.3 (October 27, 2002)

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.3.zip">dig-0.0.3.zip</A> (211Kb)
  - Added grid-fitting, that automatically locates controls based on their position in a table (Control::grid, Control::sticky).
  - Added a second example (more a sample), a port of a NeHe cartoon shading tutorial to GLFrame that adds texturing, multiple lights, simple anti-aliased plane shadows, and controls for the parameters.

  @section v0_0_2 Version 0.0.2 (October 26, 2002)

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.2.zip">dig-0.0.2.zip</A> (186Kb)
  - Added Font class (just a blackbox).
  - Added FontSelector.
  - Added ColorSelector.
  - Added GLFrame for OpenGL contexts.
  - Added the start of support for timers (Control::timer).
  - Updated the example program to show these features.

  @section v0_0_1 Version 0.0.1 (October 23, 2002)

  - File: <A href="http://www.opend.org/dig/arc/dig-0.0.1.zip">dig-0.0.1.zip</A> (136Kb)
  - Initial release.

  @section todo TODO List

  - Resizing in cartoon results in mess.
  - Menu has a std.math.single dirty scanline.
  - mat3.invert, mat2.invert, vec4's operators.
  - dedit: replace function
    only.  Lowercase and uppercase selection tools.  Show the key binding in the menus,
    key binding setup dialog.
  - dedit: blit context for
    scrolling, line insertion, and line deletion. For scrolling we'll have to buffer and then play
    back before painting, that might work
  - Canvas: Retain the bitmap if it hasn't been resized.
  - dedit: New Project, Close the current file, shouldn't crash.
  - dedit: Closing a modified file
    should produce a warning.  Delete file option.
  - dedit: Keeps locking up.
  - dedit: Two-letter compilation commands act weird.
  - dedit: Saving a project file should add an extension if necessary.
  - dedit: Indent after a local label.
  - dedit: C/C++ auto-indenting.
  - dedit: Return should remove any whitespace after the cursor.
  - dedit: Save All doesn't repaint the project view.
  - dedit: Control-G: Goto line.
  - dedit: Drop-down box for ExternalTool to insert standard expansions.
  - ListBox: Column reordering.  Right-click menu for disabling items.  Content-
    sizing columns.  Partial rendering.  Resizing last column to induce a
    horizontal scrollbar.  Non-resizable columns, non-sortable.  Selections.
  - Use the AlphaBlend function.
  - Functions for drawing path crosses and networks.
  - TrackMouseEvent is stupid, needs some crap.

  */
  
/**

  @page porting Porting and Standards
  
  Because dig isn't ported to any other platform, most of this will have
  to be based on speculation, but here's what I have now.
  
  At its most basic, it must render children in order of insertion.  Children overlapping
  must be handled.  Children that are out-of-range of their parent region must be clipped to
  them.  Painting an overlapped child must not cause flickering.  The exception is
  CanvasGL.  Overlapping a CanvasGL control has an undefined effect.
  
  Whether the result of a destination is native widgets or simulated doesn't matter to me.
  However, it's unlikely that a native widget will have all of the features needed.
  
  <ul>
  <li>Platform-specific symbols must be named with a "digPlatform" prefix.
  
  <li>Common symbols internal to dig must be named with a "digCommon" prefix.  These
  should be used sparingly.
  
  <li>Classes can have no public fields.  By public I mean those not marked with "digPlatform"
  or "digCommon"; they must not actually be hidden through "protected" or "private".
  
  <li>Structs can have no private fields.
  
  <li>American English must be used for symbol names and for documentation.
  I use Proper English normally; I'm biased against American English.  Nevertheless,
  it's the language of too many D users to ignore it.
  </ul>
  
  */
  
module net.BurtonRadons.dig.main;

import net.BurtonRadons.dig.common.brush;
import net.BurtonRadons.dig.common.math;
import net.BurtonRadons.dig.common.expressionEvaluator;
import net.BurtonRadons.dig.common.groupBox;
import net.BurtonRadons.dig.common.imageLoader;
import net.BurtonRadons.dig.common.listBox;
import net.BurtonRadons.dig.common.radioGroup;
import net.BurtonRadons.dig.common.treeBox;

import net.BurtonRadons.dig.platform.base;
import net.BurtonRadons.dig.platform.bitmap;
import net.BurtonRadons.dig.platform.button;
import net.BurtonRadons.dig.platform.canvas;
import net.BurtonRadons.dig.platform.checkBox;
import net.BurtonRadons.dig.platform.colorSelector;
import net.BurtonRadons.dig.platform.comboBox;
import net.BurtonRadons.dig.platform.control;
import net.BurtonRadons.dig.platform.editText;
import net.BurtonRadons.dig.platform.fileSelector;
import net.BurtonRadons.dig.platform.font;
import net.BurtonRadons.dig.platform.fontSelector;
import net.BurtonRadons.dig.platform.frame;
import net.BurtonRadons.dig.platform.label;
import net.BurtonRadons.dig.platform.menu;
import net.BurtonRadons.dig.platform.pane;
import net.BurtonRadons.dig.platform.radioButton;
import net.BurtonRadons.dig.platform.spinner;
